/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.service;

import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.service.VWDBExecuteInfo;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Cursor;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

class VWDBExecuteTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 2;
    protected static final int COL_STATUS = 0;
    protected static final int COL_NAME = 1;
    private Vector m_deletedDBCList = new Vector();
    private JDialog m_parentDialog = null;
    private VWSystemAdministration m_sysAdmin = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWDBExecuteTableModel(JDialog parentDialog, VWSystemAdministration sysAdmin) {
        this.m_parentDialog = parentDialog;
        this.m_sysAdmin = sysAdmin;
        this.init();
    }

    public Class getColumnClass(int nColumnIndex) {
        Class retClass = null;
        switch (nColumnIndex) {
            case 0: {
                retClass = VWDBExecuteInfo.class;
                break;
            }
            case 1: {
                retClass = String.class;
            }
        }
        return retClass;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        String colName = null;
        switch (nColumnIndex) {
            case 1: {
                colName = VWResource.Name;
                break;
            }
            default: {
                colName = null;
                return null;
            }
        }
        return colName;
    }

    public int getRowCount() {
        if (this.m_rowData == null) {
            return 0;
        }
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWDBExecuteInfo dbExInfo = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (dbExInfo == null) break;
                    return dbExInfo;
                }
                case 1: {
                    if (dbExInfo == null) break;
                    return dbExInfo.getName();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 1: {
                this.onUpdateName(aValue, nRowIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void init() {
        try {
            try {
                VWDBExecuteConnection[] dbExDefs;
                this.m_rowData = new Vector();
                if (this.m_sysAdmin != null && (dbExDefs = this.m_sysAdmin.getDBExecutionConnections()) != null) {
                    for (int nIndex = 0; nIndex < dbExDefs.length; ++nIndex) {
                        this.m_rowData.addElement(new VWDBExecuteInfo(dbExDefs[nIndex]));
                    }
                }
                Object var4_4 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_5 = null;
                this.fireTableDataChanged();
                this.m_bIsModified = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.fireTableDataChanged();
            this.m_bIsModified = false;
            throw throwable;
        }
        this.fireTableDataChanged();
        this.m_bIsModified = false;
    }

    protected void addNewDBExecute() throws Exception {
        String newDbExName = this.generateDefaultName(VWResource.DBExecuteNewTemplate, 0);
        VWDBExecuteConnection newDbExDef = new VWDBExecuteConnection();
        newDbExDef.setName(newDbExName);
        VWDBExecuteInfo newDbExInfo = new VWDBExecuteInfo(newDbExDef);
        newDbExInfo.m_nStatus |= 1;
        this.m_rowData.addElement(newDbExInfo);
        this.m_bIsModified = true;
        int nLastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(nLastRow, nLastRow);
    }

    protected void copyDBExAtIndex(int nRowIndex) {
        try {
            VWDBExecuteInfo dbExInfo = this.getRowItemAt(nRowIndex);
            if (dbExInfo != null) {
                String newName = this.generateDefaultName(VWResource.CopyOf.toString(dbExInfo.getName()), 0);
                VWDBExecuteConnection newdbExDef = new VWDBExecuteConnection();
                newdbExDef.copy(dbExInfo.m_dbExDef);
                newdbExDef.setName(newName);
                VWDBExecuteInfo newdbExInfo = new VWDBExecuteInfo(newdbExDef);
                newdbExInfo.m_nStatus |= 1;
                newdbExInfo.m_selOption = dbExInfo.m_selOption;
                newdbExInfo.setDBPWD("");
                this.m_rowData.addElement(newdbExInfo);
                this.m_bIsModified = true;
                int nLastRow = this.getRowCount() - 1;
                this.fireTableRowsInserted(nLastRow, nLastRow);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    protected void deleteDBExecuteAtIndex(int nRowIndex) {
        try {
            VWDBExecuteInfo dbExInfo = this.getRowItemAt(nRowIndex);
            this.m_deletedDBCList.addElement(dbExInfo);
            this.m_rowData.removeElement(dbExInfo);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean verifyDbExecuteConnectionAtIndex(int nRowIndex) {
        String dbExName;
        boolean bSuccess;
        block5: {
            bSuccess = false;
            dbExName = "";
            try {
                try {
                    VWDBExecuteInfo dbExInfo = this.getRowItemAt(nRowIndex);
                    dbExName = dbExInfo.getName();
                    this.m_parentDialog.setCursor(Cursor.getPredefinedCursor(3));
                    bSuccess = this.m_sysAdmin.verifyDBConnection(dbExInfo.m_dbExDef);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
                    Object var6_7 = null;
                    this.m_parentDialog.setCursor(Cursor.getPredefinedCursor(0));
                    break block5;
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.m_parentDialog.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            this.m_parentDialog.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (bSuccess) {
            JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.DBExecuteValidationSuccess.toString(dbExName), VWResource.ValidationResultTitle, 1);
            return bSuccess;
        }
        JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.DBExecuteValidationFailed.toString(dbExName), VWResource.ValidationResultTitle, 1);
        return bSuccess;
    }

    protected VWDBExecuteInfo getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWDBExecuteInfo)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected void releaseResources() {
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        this.m_sysAdmin = null;
    }

    protected boolean update() {
        try {
            int rowCount = this.m_rowData.size();
            for (int i = 0; i < rowCount; ++i) {
                try {
                    VWDBExecuteInfo dbExInfo = (VWDBExecuteInfo)this.m_rowData.elementAt(i);
                    dbExInfo.update();
                    if (!dbExInfo.isNew()) continue;
                    VWDBExecuteConnection newDBCDef = this.m_sysAdmin.createDBExecutionConnection(dbExInfo.getName());
                    newDBCDef.copy(dbExInfo.m_dbExDef);
                    continue;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.DBExecuteConnectionProcessError.toString(String.valueOf(i + 1), ex.getLocalizedMessage()), 1);
                    return false;
                }
            }
            if (this.m_deletedDBCList != null) {
                rowCount = this.m_deletedDBCList.size();
                VWDBExecuteInfo dbExInfo = null;
                for (int i = 0; i < rowCount; ++i) {
                    try {
                        dbExInfo = (VWDBExecuteInfo)this.m_deletedDBCList.elementAt(i);
                        if (dbExInfo.isNew()) continue;
                        VWDBExecuteConnection aDbExDef = dbExInfo.m_dbExDef;
                        this.m_sysAdmin.deleteDBExecutionConnection(aDbExDef);
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.FailedToDeleteDBExecute.toString(dbExInfo.getName(), ex.getLocalizedMessage()), 1);
                        return false;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    protected boolean validateDBExecutes() {
        boolean bSuccess = true;
        try {
            int rowCount = this.m_rowData.size();
            for (int i = rowCount - 1; i >= 0; --i) {
                VWDBExecuteInfo dbExInfo = (VWDBExecuteInfo)this.m_rowData.elementAt(i);
                String name = dbExInfo.getName();
                if (name == null || name.length() < 1) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.MissingDBExecuteName.toString(dbExInfo.getName()), 1);
                    return false;
                }
                for (int j = 0; j < rowCount; ++j) {
                    VWDBExecuteInfo tmpdbExInfo = (VWDBExecuteInfo)this.m_rowData.elementAt(j);
                    if (name.compareTo(tmpdbExInfo.getName()) != 0 || j == i) continue;
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.DuplicatedDBExecuteName.toString(name, String.valueOf(j + 1)), 1);
                    return false;
                }
                String jdbcUrl = dbExInfo.getURL();
                if (jdbcUrl == null || jdbcUrl.length() < 1) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.MissingJDBCConnectionURL.toString(dbExInfo.getName()), 1);
                    return false;
                }
                if (jdbcUrl.contains(VWResource.TemplateDatabase)) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.JDBCURLReplaceDBName.toString(dbExInfo.getName()), 1);
                    return false;
                }
                if (jdbcUrl.contains(VWResource.TemplateHost)) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.JDBCURLReplaceDBHost.toString(dbExInfo.getName()), 1);
                    return false;
                }
                if (jdbcUrl.contains(VWResource.TemplatePort)) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.JDBCURLReplaceDBPort.toString(dbExInfo.getName()), 1);
                    return false;
                }
                String userName = dbExInfo.getDBUser();
                if (userName == null || userName.length() < 1) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.MissingDBExecuteDBUserName.toString(dbExInfo.getName()), 1);
                    return false;
                }
                if (!dbExInfo.isNew() && dbExInfo.m_reenterPWD) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.DBExecuteReEnterPWD.toString(dbExInfo.getName()), 1);
                    return false;
                }
                String pwd = dbExInfo.getDBPWD();
                if (dbExInfo.m_nStatus == 0 || pwd != null && pwd.trim().length() >= 1) continue;
                VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.DBExecuteEnterPWD.toString(dbExInfo.getName()), 1);
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    private String generateDefaultName(String template, int postfix) throws VWException {
        int rowCount = this.m_rowData.size();
        boolean bHasDup = false;
        String defaultName = template;
        do {
            bHasDup = false;
            for (int j = 0; j < rowCount; ++j) {
                VWDBExecuteInfo tmpdbExInfo = (VWDBExecuteInfo)this.m_rowData.elementAt(j);
                if (defaultName.compareTo(tmpdbExInfo.getName()) != 0) continue;
                defaultName = String.format("%s_%d", template, ++postfix);
                bHasDup = true;
                break;
            }
            if (bHasDup || this.m_sysAdmin.getDBExecutionConnection(defaultName) == null) continue;
            defaultName = String.format("%s_%d", template, ++postfix);
            bHasDup = true;
        } while (bHasDup);
        return defaultName;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            String name = (String)aValue;
            if (name == null || name.length() <= 0) {
                VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.InvalidDBExecuteName.toString(name, String.valueOf(nRowIndex + 1)), 1);
                return;
            }
            int rowCount = this.m_rowData.size();
            for (int i = 0; i < rowCount; ++i) {
                VWDBExecuteInfo dbExInfo = (VWDBExecuteInfo)this.m_rowData.elementAt(i);
                if (name.compareTo(dbExInfo.getName()) != 0 || i == nRowIndex) continue;
                VWMessageDialog.showOptionDialog(this.m_parentDialog, VWResource.DuplicatedDBExecuteName.toString(name, String.valueOf(i + 1)), 1);
                return;
            }
            VWDBExecuteInfo dbExInfo = this.getRowItemAt(nRowIndex);
            if (dbExInfo != null) {
                dbExInfo.setName((String)aValue);
                this.fireTableCellUpdated(nRowIndex, 1);
                this.m_bIsModified = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }
}

